using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.AssistedRegistration
{
    public class UnregisteredViewModel
    {
        [Display(Name = "Hospital")]
        public string HospitalCode { get; set; }

        #region Data Properties

        public IEnumerable<SelectListItem> Hospitals { get; internal set; }
        public List<UnregisteredPatientViewModel> UnregisteredPatients { get; internal set; }

        #endregion

        public UnregisteredViewModel()
        {
            Hospitals = Enumerable.Empty<SelectListItem>();
            UnregisteredPatients = new List<UnregisteredPatientViewModel>();
        }
    }
}